public class Exec extends Employee {
  private int salary; // Yearly salary for exec
  private int bonus;  // Bonus for exec
  
  /** Constructor: an instance with name n,
      year d hired, salary s, and bonus b */
  public Exec(String n, int d, int s, int b) {
    super(n,d);
    salary= s; 
    bonus= b;
  }
  
  /** Constructor: an instance with name n, start year 2000,
      salary s, and bonus 0 */
  public Exec(String n, int s) {
    this(n, 2000, s, 0);
  }
  
  /** = the yearly salary for this Exec */
  public int getSalary() {
    return salary;
  }  
  
  /** Set the salary for this Exec to s */
  public void setSalary(int s) {
    salary= s;
  }
  
  /** = the yearly bonus for this Exec */
  public int getBonus() {
    return bonus;
  }  
  
  /** Set the bonus for this Exec to b */
  public void setBonus(int b) {
    bonus= b;
  }

  /** = Executive's total yearly compensation */
  public int getCompensation() {
    return salary + bonus;
  }
  
  /** = String description of this Exec */
  public String toString() {
    String r= "Executive: " + super.toString();
    r= r + ", salary " + salary;
    r= r + ", bonus " + bonus;
    return r;
  }
  
}
